const express = require('express');
const router = express.Router();
const db = require('../db');

// Home Page
router.get('/', (req, res) => {
  db.query('SELECT * FROM blogs WHERE is_published = 1', (err, results) => {
    if (err) return res.send('Database error');
    res.render('index'); // Make sure you're using `blogs`
  });
});

router.get('/blog/:slug', (req, res) => {
  const slug = req.params.slug;
  db.query('SELECT * FROM blogs WHERE slug = ? AND is_published = 1', [slug], (err, result) => {
    if (err || result.length === 0) return res.status(404).send('Blog not found');
    res.render('blog', { blog: result[0] });
  });
});


module.exports = router;
