const express = require('express');
const session = require('express-session');
const path = require('path');

const blogRoutes = require('./server/routes/blog.js');
const adminRoutes = require('./server/routes/admin.js');

const app = express();

// View engine
app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'views'));



// Middlewares
app.use(express.urlencoded({ extended: true }));
app.use(express.json());
app.use(express.static(path.join(__dirname, '../public')));
app.use('/uploads', express.static(path.join(__dirname, 'server', 'public', 'uploads', 'blogs')));

function isLoggedIn(req, res, next) {
  if (req.session && req.session.user) {
    return next();
  }
  res.redirect('/login');
}


app.use(session({
  secret: 'mySecret123',
  resave: false,
  saveUninitialized: true
}));

// Routes
app.use('/', blogRoutes);
app.use('/admin', adminRoutes);

// Server
app.listen(3001, () => {
  console.log('🚀 Server running at http://localhost:3001');
});
